/*-----------------------------------------------------------------------*/
/* Copyright 2012 to current year.                                       */
/* AVEVA Solutions Limited and its subsidiaries. All rights reserved.    */
/*-----------------------------------------------------------------------*/
(function (angular) {
  'use strict';

  var netviewNotification = function (
    scope,
    netviewListener,
    netviewWrapper,
    itemService
  ) {
    var tagMatch = function (tag1, tag2) {
      return (
        tag1 === tag2 || tag1.indexOf(tag2) > -1 || tag2.indexOf(tag1) > -1
      );
    };

    var notificationObj = {
      netviewLastCall: false,
      aNetLastCall: false,
      netviewNotifications: { preSent: null, postSent: null },
      aNetNotifications: { preSent: null, postSent: null },
      scope: scope,
      netviewWrapper: netviewWrapper,
      netviewReady: false,

      addNetViewNotification: function (notification) {
        this.netviewNotifications.preSent = notification;
        if (this.netviewReady) {
          this.processNotifications();
        }
      },

      addANetNotification: function (notification) {
        this.aNetNotifications.preSent = notification;
        if (this.netviewReady) {
          this.processNotifications();
        }
      },

      itemInQueueToNetView: function (tag) {
        var result = false;
        if (this.netviewNotifications.preSent) {
          result =
            result || tagMatch(this.netviewNotifications.preSent.id, tag);
        }
        if (this.netviewNotifications.postSent) {
          result =
            result || tagMatch(this.netviewNotifications.postSent.id, tag);
          this.netviewLastCall = true;
        }
        return result;
      },

      itemInQueueToANet: function (tag) {
        var result = false;
        if (this.aNetNotifications.preSent) {
          result = result || tagMatch(this.aNetNotifications.preSent.id, tag);
        }
        if (this.aNetNotifications.postSent) {
          result = result || tagMatch(this.aNetNotifications.postSent.id, tag);
          this.aNetLastCall = true;
        }
        return result;
      },

      itemInQueue: function (tag) {
        return this.itemInQueueToNetView(tag) || this.itemInQueueToANet(tag);
      },

      processNotifications: function () {
        if (this.netviewNotifications.preSent) {
          this.netviewWrapper.selection(
            this.netviewNotifications.preSent.id,
            this.netviewNotifications.preSent.classId
          );
          this.netviewNotifications.postSent = this.netviewNotifications.preSent;
          this.netviewNotifications.preSent = null;
          this.netviewLastCall = false;
        }
        if (this.aNetNotifications.preSent) {
          this.scope.itemSelectedHandler(this.aNetNotifications.preSent.id);
          this.aNetNotifications.postSent = this.aNetNotifications.preSent;
          this.aNetNotifications.preSent = null;
          this.aNetLastCall = false;
        }
      },

      setNetViewReady: function () {
        this.netviewReady = true;
        this.processNotifications();
      }
    };

    scope.$watch(
      'currentTab',
      function (changedTab) {
        if (changedTab && changedTab.selectedFullId) {
          var fullTagNameSplit = changedTab.selectedFullId.split('|');
          var tagName = fullTagNameSplit[fullTagNameSplit.length - 1];
          scope.aNetSuspendNotifications();
          itemService.get(tagName).then(
            function (item) {
              if (!notificationObj.itemInQueue(item.id)) {
                notificationObj.addNetViewNotification({
                  id: item.id,
                  classId: item.classId
                });
                scope.itemSelectedHandler(item.id);
              }
              scope.aNetResumeNotifications();
            },
            function (err) {
              scope.aNetResumeNotifications();
            }
          );
        }
      },
      true
    );

    scope.$watch('itemsToSelect', function (items) {
      if (Array.isArray(items) && items.length > 0) {
        itemService.get(items[0]).then(function (item) {
          if (
            !notificationObj.itemInQueue(item.id) ||
            notificationObj.netviewLastCall
          ) {
            notificationObj.addNetViewNotification({
              id: item.id,
              classId: item.classId
            });
          }
        });
      }
    });

    netviewListener.addNotifyFunction(function (id) {
      if (angular.isFunction(scope.itemSelectedHandler)) {
        scope.aNetSuspendNotifications();
        itemService.get(id).then(
          function (item) {
            if (
              !notificationObj.itemInQueue(item.id) ||
              notificationObj.aNetLastCall
            ) {
              notificationObj.addANetNotification({
                id: item.id,
                classId: item.classId
              });
            }
            scope.aNetResumeNotifications();
          },
          function (err) {
            scope.aNetResumeNotifications();
          }
        );
      }
    });

    return notificationObj;
  };

  var aNetDashModule = angular.module('aveva.dashboard.custom');

  aNetDashModule.factory('NetViewNotificationService', function () {
    return netviewNotification;
  });
})(angular);
